/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import java.util.List;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureTypeDictionary;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.jobs.JobStore;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobType;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.designation.TileDesignation;
import technology.rocketjump.undermount.messaging.types.DoorwayPlacementMessage;
import technology.rocketjump.undermount.misc.VectorUtils;
import technology.rocketjump.undermount.rendering.HexColors;
import technology.rocketjump.undermount.rendering.RenderMode;
import technology.rocketjump.undermount.rendering.RenderingOptions;
import technology.rocketjump.undermount.rendering.RoomRenderer;
import technology.rocketjump.undermount.rendering.WorldRenderer;
import technology.rocketjump.undermount.rendering.entities.EntityRenderer;
import technology.rocketjump.undermount.rooms.RoomTypeDictionary;
import technology.rocketjump.undermount.sprites.TerrainSpriteCache;
import technology.rocketjump.undermount.ui.GameInteractionMode;
import technology.rocketjump.undermount.ui.GameInteractionStateContainer;

public class InWorldUIRenderer {
    public static final String VALID_PLACEMENT_COLOR = "#00ee00aa";
    public static final String INVALID_PLACEMENT_COLOR = "#ee0000aa";
    private final GameInteractionStateContainer interactionStateContainer;
    private final EntityRenderer entityRenderer;
    private final ShapeRenderer shapeRenderer = new ShapeRenderer();
    private final SpriteBatch spriteBatch = new SpriteBatch();
    private final RoomRenderer roomRenderer;
    private final RenderingOptions renderingOptions;
    private final JobStore jobStore;
    private final Sprite doorIconSprite;

    @Inject
    public InWorldUIRenderer(GameInteractionStateContainer interactionStateContainer, EntityRenderer entityRenderer, RoomRenderer roomRenderer, RenderingOptions renderingOptions, JobStore jobStore, FurnitureTypeDictionary furnitureTypeDictionary, TextureAtlasRepository textureAtlasRepository) {
        this.interactionStateContainer = interactionStateContainer;
        this.entityRenderer = entityRenderer;
        this.roomRenderer = roomRenderer;
        this.renderingOptions = renderingOptions;
        this.jobStore = jobStore;
        FurnitureType singleDoorType = furnitureTypeDictionary.getByName("SINGLE_DOOR");
        this.doorIconSprite = textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.GUI_TEXTURE_ATLAS).createSprite(singleDoorType.getIconName());
    }

    public void render(TiledMap map, OrthographicCamera camera, TerrainSpriteCache diffuseSpriteCache) {
        DoorwayPlacementMessage virtualDoorPlacement;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.shapeRenderer.setProjectionMatrix(camera.combined);
        this.spriteBatch.setProjectionMatrix(camera.combined);
        int minX = WorldRenderer.getMinX(camera);
        int maxX = WorldRenderer.getMaxX(camera, map);
        int minY = WorldRenderer.getMinY(camera);
        int maxY = WorldRenderer.getMaxY(camera, map);
        this.interactionStateContainer.update(map);
        Vector2 minDraggingPoint = this.interactionStateContainer.getMinPoint();
        Vector2 maxDraggingPoint = this.interactionStateContainer.getMaxPoint();
        GridPoint2 minDraggingTile = new GridPoint2(MathUtils.floor(minDraggingPoint.x), MathUtils.floor(minDraggingPoint.y));
        GridPoint2 maxDraggingTile = new GridPoint2(MathUtils.floor(maxDraggingPoint.x), MathUtils.floor(maxDraggingPoint.y));
        if (this.interactionStateContainer.isDragging() && this.interactionStateContainer.getInteractionMode().isDesignation()) {
            this.drawDragAreaOutline(minDraggingPoint, maxDraggingPoint);
        }
        if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.DEFAULT)) {
            Entity selectedEntity = this.interactionStateContainer.getSelectedEntity();
            if (selectedEntity != null) {
                this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
                this.shapeRenderer.setColor(Color.WHITE);
                this.shapeRenderer.circle(selectedEntity.getLocationComponent().getWorldPosition().x, selectedEntity.getLocationComponent().getWorldPosition().y, selectedEntity.getLocationComponent().getRadius() + 0.3f, 100);
                this.shapeRenderer.end();
            }
        } else if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.PLACE_FURNITURE)) {
            Color furnitureColor = HexColors.get(VALID_PLACEMENT_COLOR);
            if (!this.interactionStateContainer.isValidFurniturePlacement()) {
                furnitureColor = HexColors.get(INVALID_PLACEMENT_COLOR);
            }
            Entity furnitureEntity = this.interactionStateContainer.getFurnitureEntityToPlace();
            this.spriteBatch.begin();
            this.entityRenderer.render(furnitureEntity, (Batch)this.spriteBatch, RenderMode.DIFFUSE, null, furnitureColor);
            this.spriteBatch.end();
            this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            this.shapeRenderer.setColor(furnitureColor);
            GridPoint2 furnitureGridPoint = VectorUtils.toGridPoint(furnitureEntity.getLocationComponent().getWorldPosition());
            FurnitureEntityAttributes attributes = (FurnitureEntityAttributes)furnitureEntity.getPhysicalEntityComponent().getAttributes();
            for (FurnitureLayout.Workspace workspace : attributes.getCurrentLayout().getWorkspaces()) {
                GridPoint2 workspaceAccessedFrom = furnitureGridPoint.cpy().add(workspace.getAccessedFrom());
                this.shapeRenderer.circle((float)workspaceAccessedFrom.x + 0.5f, (float)workspaceAccessedFrom.y + 0.5f, 0.35f, 50);
            }
            this.shapeRenderer.end();
        } else if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.PLACE_DOOR) && (virtualDoorPlacement = this.interactionStateContainer.getVirtualDoorPlacement()) != null) {
            Color doorPlacementColor = HexColors.get(VALID_PLACEMENT_COLOR);
            if (!this.interactionStateContainer.isValidDoorPlacement()) {
                doorPlacementColor = HexColors.get(INVALID_PLACEMENT_COLOR);
            }
            this.spriteBatch.begin();
            this.spriteBatch.setColor(doorPlacementColor);
            this.spriteBatch.draw(this.doorIconSprite, (float)virtualDoorPlacement.getTilePosition().x, (float)virtualDoorPlacement.getTilePosition().y, 1.0f, 1.0f);
            this.spriteBatch.end();
        }
        this.spriteBatch.begin();
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = maxY; y >= minY; --y) {
                MapTile mapTile = map.getTile(x, y);
                if (mapTile == null) continue;
                if (this.insideSelectionArea(minDraggingTile, maxDraggingTile, x, y)) {
                    if (!this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.REMOVE_DESIGNATIONS)) {
                        if (this.interactionStateContainer.getInteractionMode().designationName != null) {
                            if (this.shouldHighlight(mapTile)) {
                                TileDesignation designationToApply = this.interactionStateContainer.getInteractionMode().getDesignationToApply();
                                this.spriteBatch.setColor(designationToApply.getSelectionColor());
                                this.spriteBatch.draw(designationToApply.getIconSprite(), (float)x, (float)y, 1.0f, 1.0f);
                            } else {
                                this.renderExistingDesignation(x, y, mapTile);
                            }
                        } else if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.PLACE_ROOM)) {
                            // empty if block
                        }
                    }
                } else {
                    this.renderExistingDesignation(x, y, mapTile);
                }
                if (mapTile.hasRoom() && mapTile.getRoomTile().getRoom().getRoomType().getRoomName().equals(RoomTypeDictionary.VIRTUAL_PLACING_ROOM.getRoomName())) {
                    this.roomRenderer.render(mapTile, this.spriteBatch, diffuseSpriteCache);
                }
                if (!this.renderingOptions.debug().showJobStatus()) continue;
                List<Job> jobsAtLocation = this.jobStore.getJobsAtLocation(mapTile.getTilePosition());
                for (Job jobAtLocation : jobsAtLocation) {
                    switch (jobAtLocation.getJobState()) {
                        case ASSIGNABLE: {
                            this.spriteBatch.setColor(Color.GREEN);
                            this.shapeRenderer.setColor(Color.GREEN);
                            break;
                        }
                        case ASSIGNED: {
                            this.spriteBatch.setColor(Color.BLUE);
                            this.shapeRenderer.setColor(Color.BLUE);
                            break;
                        }
                        case POTENTIALLY_ACCESSIBLE: {
                            this.spriteBatch.setColor(Color.ORANGE);
                            this.shapeRenderer.setColor(Color.ORANGE);
                            break;
                        }
                        case PROCESSING_ACCESSIBILITY: {
                            this.spriteBatch.setColor(Color.YELLOW);
                            this.shapeRenderer.setColor(Color.YELLOW);
                            break;
                        }
                        case INACCESSIBLE: {
                            this.spriteBatch.setColor(Color.RED);
                            this.shapeRenderer.setColor(Color.RED);
                        }
                    }
                    if (jobAtLocation.getType().equals((Object)JobType.HAULING)) {
                        this.shapeRenderer.line((float)jobAtLocation.getJobLocation().x + 0.5f, (float)jobAtLocation.getJobLocation().y + 0.5f, (float)jobAtLocation.getItemAllocation().getTargetPosition().x + 0.5f, (float)jobAtLocation.getItemAllocation().getTargetPosition().y + 0.5f);
                        continue;
                    }
                    if (mapTile.getDesignation() == null) continue;
                    this.spriteBatch.draw(mapTile.getDesignation().getIconSprite(), (float)x, (float)y, 1.0f, 1.0f);
                }
            }
        }
        this.spriteBatch.end();
        this.shapeRenderer.end();
    }

    private void renderExistingDesignation(int x, int y, MapTile mapTile) {
        if (mapTile.getDesignation() != null) {
            TileDesignation designation = mapTile.getDesignation();
            this.spriteBatch.setColor(designation.getDesignationColor());
            this.spriteBatch.draw(designation.getIconSprite(), (float)x, (float)y, 1.0f, 1.0f);
        }
    }

    private boolean insideSelectionArea(GridPoint2 minDraggingTile, GridPoint2 maxDraggingTile, int x, int y) {
        return this.interactionStateContainer.isDragging() && minDraggingTile.x <= x && x <= maxDraggingTile.x && minDraggingTile.y <= y && y <= maxDraggingTile.y;
    }

    private boolean shouldHighlight(MapTile mapTile) {
        if (this.interactionStateContainer.getInteractionMode().designationCheck != null) {
            return this.interactionStateContainer.getInteractionMode().designationCheck.shouldDesignationApply(mapTile);
        }
        return false;
    }

    private void drawDragAreaOutline(Vector2 minDraggingPoint, Vector2 maxDraggingPoint) {
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.setColor(Color.WHITE);
        this.shapeRenderer.rect(minDraggingPoint.x, minDraggingPoint.y, maxDraggingPoint.x - minDraggingPoint.x, maxDraggingPoint.y - minDraggingPoint.y);
        this.shapeRenderer.end();
    }
}

